package chess4j;

public enum Color {
	BLACK(0),
	WHITE(1);
	
	private int _color;
	
	private Color(int color) {
		_color=color;
	}
	
	public int getColor() {
		return _color;
	}
	
	public static Color swap(Color c) {
		return c.getColor()==0?WHITE:BLACK;
	}
	
	public boolean equals(Color c) {
		if (c==null) return false;
		return c.getColor()==_color;
	}
	
	public boolean isBlack() {
		return _color==0;
	}
	
	public boolean isWhite() {
		return _color==1;
	}
	
	public String toString() {
		if (_color==BLACK.getColor())
			return "black";
		else
			return "white";
	}
}
